(function (Drupal, once) {
  Drupal.behaviors.plotlyInit = {
    attach: function (context) {
      once('plotlyInit', '.plotly-chart', context).forEach(function (el) {
        let configEl = el.querySelector('.plotly-config');
        if (configEl) {
          let config = JSON.parse(configEl.textContent);
          Plotly.newPlot(el.id, config.data, config.layout, {responsive: true, scrollZoom: true});
        }
      });
    }
  };
})(Drupal, once);
