<?php

declare(strict_types=1);

namespace Drupal\plotly;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for plotly chart plugins.
 */
abstract class PlotlyChartPluginBase extends PluginBase implements PlotlyChartInterface {

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

}
