<?php

namespace Drupal\plotly;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\plotly\Attribute\PlotlyChart;

/**
 * Plotly chart plugin manager.
 */
class PlotlyChartPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/PlotlyChart',
      $namespaces,
      $module_handler,
      PlotlyChartInterface::class,
      PlotlyChart::class
    );
    $this->alterInfo('plotlychart_info');
    $this->setCacheBackend($cache_backend, 'plotlychart_plugins');
  }

}
