<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'bubble',
  label: new TranslatableMarkup('Bubble charts'),
  description: new TranslatableMarkup('Bubble charts'),
  example: 'https://plotly.com/javascript/bubble-charts/',
  category: 'Basic Charts',
)]
class Bubble implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $display_type = $options['webgl'] ? 'scattergl' : 'scatter';
    $x = $series = $texts = $sizes = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $x[] = $view->style_plugin->getField($row_index, $options['label']);
      foreach (array_keys($options['fields']) as $field_name) {
        if ($field_name === $options['label']) {
          continue;
        }
        $value = $view->style_plugin->getField($row_index, $field_name);
        if ($field_name === $options['text']) {
          $texts[$field_name][] = $value;
          continue;
        }
        if ($field_name === $options['size']) {
          $sizes[$field_name][] = $value;
          continue;
        }
        $series[$field_name][] = $value;
      }
    }
    $traces = [];
    $mode = 'markers';
    foreach ($series as $field_name => $values) {
      $label = $options['fields'][$field_name]['name'] ?? $field_name;
      $color = $options['fields'][$field_name]['color'] ?? '';
      $traces[] = [
        'name' => $label,
        'x' => !empty($options['horizontal']) ? $values : $x,
        'y' => !empty($options['horizontal']) ? $x : $values,
        'orientation' => !empty($options['horizontal']) ? 'h' : '',
        'text' => !empty($texts) ? current($texts) : '',
        'type' => $display_type,
        'mode' => $mode,
        'marker' => [
          'color' => $color === '#000000' ? '' : $color,
          'size' => !empty($sizes) ? current($sizes) : 10,
          'sizemode' => 'area',
        ],
      ];
    }
    return [
      'data' => $traces,
      'layout' => $layout + [
        'showlegend' => FALSE,
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Bubble Chart'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'showarrow' => FALSE,
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
