<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'carpet',
  label: new TranslatableMarkup('Carpet Plots'),
  description: new TranslatableMarkup('Carpet Plots needs 3 fields'),
  example: 'https://plotly.com/javascript/carpet-plot/',
  category: 'Scientific Charts',
)]
class Carpet implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $display_type = 'carpet';
    $values = $texts = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $texts[] = $view->style_plugin->getField($row_index, $options['text']);
      foreach (array_keys($options['fields']) as $field_name) {
        if ($field_name === $options['text']) {
          continue;
        }
        $values[$field_name][] = $view->style_plugin->getField($row_index, $field_name);
      }
    }
    $trace = [
      'type' => $display_type,
      'text' => $texts,
    ];
    foreach (['a', 'b', 'y'] as $axis) {
      $trace[$axis] = array_pop($values);
    }
    return [
      'data' => [$trace],
      'layout' => $layout+ [
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Carpet Plots'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
