<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'contour',
  label: new TranslatableMarkup('Contour Plots'),
  description: new TranslatableMarkup('Contour Plots show only 3 fields'),
  example: 'https://plotly.com/javascript/contour-plots/',
  category: 'Scientific Charts',
)]
class Contour implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $x = $y = $z = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $x[] = $view->style_plugin->getField($row_index, $options['label']);
      $y[] = $view->style_plugin->getField($row_index, $options['text']);
      foreach (array_keys($options['fields']) as $field_name) {
        if ($field_name === $options['label'] || $field_name === $options['text']) {
          continue;
        }
        $value = $view->style_plugin->getField($row_index, $field_name);
        $z[$field_name][] = $value;
      }
    }
    $display_type = 'contour';
    $color = $options['fields']['label']['color'] ?? 'Jet';
    $traces[] = [
      'x' => $x,
      'y' => $y,
      'z' => array_values($z),
      'type' => $display_type,
      'colorscale' => $color === '#000000' ? 'Jet' : $color,
      'contours' => ['showlabels' => TRUE],
    ];
    return [
      'data' => $traces,
      'layout' => $layout + [
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Contour Plots'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'showarrow' => FALSE,
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
        'barmode' => !empty($options['stacked']) ? 'stack' : 'overlay',
      ],
    ];
  }

}
