<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'funnel',
  label: new TranslatableMarkup('Funnel plot'),
  description: new TranslatableMarkup('Funnel plot'),
  example: 'https://plotly.com/javascript/funnel-charts/',
  category: 'Financial Charts',
)]
class Funnel implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $display_type = 'funnel';
    $series = $y = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $y[] = $view->style_plugin->getField($row_index, $options['text']);
      foreach (array_keys($options['fields']) as $field_name) {
        if ($field_name === $options['text']) {
          continue;
        }
        $value = $view->style_plugin->getField($row_index, $field_name);
        $series[$field_name][] = $value;
      }
    }
    $traces = [];
    foreach ($series as $field_name => $values) {
      $label = $options['fields'][$field_name]['name'] ?? $field_name;
      $color = $options['fields'][$field_name]['color'] ?? '';
      $traces[] = [
        'name' => $label,
        'x' => $values,
        'y' => !empty($y) ? $y : '',
        'type' => $display_type,
        'marker' => [
          'color' => $color === '#000000' ? '' : $color,
          'size' => $options['fields'][$field_name]['size'] ?? 10,
        ],
      ];
    }
    return [
      'data' => $traces,
      'layout' => $layout + [
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Funnel Charts'),
        ],
        'polar' => [
          'barmode' => "overlay",
          'bargap' => 0,
          'angularaxis' => ['direction' => "clockwise"],
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
