<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'histogram2dcontour',
  label: new TranslatableMarkup('2D Histogram Contour'),
  description: new TranslatableMarkup('2D Histogram Contour show only 2 fields'),
  example: 'https://plotly.com/javascript/2d-histogram-contour/',
  category: 'Statistical Charts',
)]
class Histogram2DContour implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $x = $y = $series = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $x[] = $view->style_plugin->getField($row_index, $options['label']);
      $y[] = $view->style_plugin->getField($row_index, $options['text']);
    }
    $display_type = 'histogram2dcontour';
    $color = $options['fields']['label']['color'] ?? '';
    $traces[] = [
      'x' => $x,
      'y' => $y,
      'type' => $display_type,
      'colorscale' => $color === '#000000' ? '' : $color,
      'contours' => ['showlabels' => TRUE],
    ];
    return [
      'data' => $traces,
      'layout' => $layout + [
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Histograms Chart'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'showarrow' => FALSE,
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
        'barmode' => !empty($options['stacked']) ? 'stack' : 'overlay',
      ],
    ];
  }

}
