<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'indicator',
  label: new TranslatableMarkup('Indicators'),
  description: new TranslatableMarkup('Indicators'),
  example: 'https://plotly.com/javascript/indicator/',
  category: 'Financial Charts',
)]
class Indicators implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $display_type = 'indicator';
    $data = [];
    $line = $col = 0;
    $totalCol = 4;
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $values = [
        'type' => $display_type,
        'mode' => "number+delta",
        'domain' => ['row' => $line, 'column' => $col++],
      ];
      if ($col === $totalCol) {
        $col = 0;
        $line++;
      }
      foreach (array_keys($options['fields']) as $field_name) {
        $value = $view->style_plugin->getField($row_index, $field_name);
        switch ($field_name) {
          case $options['label']:
            $values['value'] = $value;
            break;

          case $options['text']:
            $values['title'] = ['text' => $value];
            break;

          default:
            $values['delta'] = ['reference' => $value];
            break;
        }
      }
      $data[] = $values;
    }

    return [
      'data' => $data,
      'layout' => $layout + [
        'autosize' => TRUE,
        'showlegend' => TRUE,
        'grid' => ['rows' => $line + 1, 'columns' => $totalCol, 'pattern' => 'independent'],
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Indicators'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
