<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'line3d',
  label: new TranslatableMarkup('3D Line Plots'),
  description: new TranslatableMarkup('3D Line Plots'),
  example: 'https://plotly.com/javascript/3d-line-plots/',
  category: '3D Charts',
)]
class Line3D implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $x = $y = $z = $c = $series = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      foreach (array_keys($options['fields']) as $field_name) {
        $value = $view->style_plugin->getField($row_index, $field_name);
        switch ($field_name) {
          case $options['label']:
            $x[$field_name][] = $value;
            break;

          case $options['text']:
            $z[$field_name][] = $value;
            break;

          case $options['size']:
            $y[$field_name][] = $value;
            break;

          case $options['parent']:
            $c[$field_name][] = $value;
            break;

          default:
            $series[$field_name][] = $value;
            break;
        }
      }
    }
    $display_type = 'scatter3d';
    $mode = 'lines';
    $traces = [
      'type' => $display_type,
      'mode' => $mode,
      'x' => reset($x),
      'y' => reset($y),
      'z' => reset($z),
      'opacity' => 1,
      'line' => [
        'width' => 6,
        'color' => reset($c),
        'reversescale' => FALSE,
      ],
    ];
    return [
      'data' => [$traces],
      'layout' => $layout + [
        'scene' => [
          'xaxis' => ['title' => ['text' => $options['fields'][$options['label']]['name'] ?? '']],
          'yaxis' => ['title' => ['text' => $options['fields'][$options['text']]['name'] ?? '']],
          'zaxis' => ['title' => ['text' => $options['fields'][$options['size']]['name'] ?? '']],
        ],
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Mesh Plots'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
