<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'mesh3d',
  label: new TranslatableMarkup('3D Mesh Plots'),
  description: new TranslatableMarkup('3D Mesh Plots'),
  example: 'https://plotly.com/javascript/3d-mesh/',
  category: '3D Charts',
)]
class Mesh3D implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $x = $y = $z = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      foreach (array_keys($options['fields']) as $field_name) {
        $value = $view->style_plugin->getField($row_index, $field_name);
        if ($field_name === $options['label']) {
          $x[$field_name][] = $value;
          continue;
        }
        if ($field_name === $options['text']) {
          $z[$field_name][] = $value;
          continue;
        }
        $y[$field_name][] = $value;
      }
    }
    $traces = [];
    $display_type = 'mesh3d';
    foreach ($y as $field_name => $values) {
      $label = $options['fields'][$field_name]['name'] ?? $field_name;
      $color = $options['fields'][$field_name]['color'] ?? '';
      $mode = $options['fields'][$field_name]['mode'] ?? 'lines+markers';
      $traces[] = [
        'name' => $label,
        'x' => reset($x),
        'y' => $values,
        'z' => reset($z),
        'type' => $display_type,
        'mode' => $mode,
        'color' => $color,
        'opacity' => 0.8,
      ];
    }
    return [
      'data' => $traces,
      'layout' => $layout + [
        'scene' => [
          'xaxis' => ['title' => ['text' => $options['fields'][$options['label']]['name'] ?? '']],
          'yaxis' => ['title' => ['text' => $options['fields'][$field_name]['name'] ?? '']],
          'zaxis' => ['title' => ['text' => $options['fields'][$options['text']]['name'] ?? '']],
        ],
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Mesh Plots'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
