<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'parcats',
  label: new TranslatableMarkup('Parallel Categories Diagram'),
  description: new TranslatableMarkup('Parallel Categories Diagram'),
  example: 'https://plotly.com/javascript/parallel-categories-diagram/',
  category: 'Scientific Charts',
)]
class Parcats implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $series = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      foreach (array_keys($options['fields']) as $field_name) {
        $value = $view->style_plugin->getField($row_index, $field_name);
        $series[$field_name][] = $value;
      }
    }
    $traces = [];
    $display_type = 'parcats';
    foreach ($series as $field_name => $values) {
      $label = $options['fields'][$field_name]['name'] ?? $field_name;
      $color = $options['fields'][$field_name]['color'] ?? '';
      $traces[] = [
        'type' => $display_type,
        'dimensions' => [
          'label' => $label,
          'values' => $values,
        ],
        'hoveron' => 'color',
        'line' => [
          'color' => $color === '#000000' ? '' : $color,
        ],
      ];
    }
    return [
      'data' => $traces,
      'layout' => $layout + [
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Parallel Categories Diagram'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
