<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'parcoords',
  label: new TranslatableMarkup('Parallel Coordinates Plot'),
  description: new TranslatableMarkup('Parallel Coordinates Plot'),
  example: 'https://plotly.com/javascript/parallel-coordinates-plot/',
  category: 'Scientific Charts',
)]
class Parcoords implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $series = $texts = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      foreach (array_keys($options['fields']) as $field_name) {
        $value = $view->style_plugin->getField($row_index, $field_name);
        if ($field_name === $options['text']) {
          $texts[$field_name][] = $value;
          continue;
        }
        $series[$field_name][] = $value;
      }
    }
    $display_type = 'parcoords';
    $dimensions = [];
    foreach ($series as $field_name => $values) {
      $label = $options['fields'][$field_name]['name'] ?? $field_name;
      $dimensions[] = [
        'label' => $label,
        'values' => $values,
        'ticktext' => !empty($texts) ? current($texts) : '',
      ];
    }
    $trace = [
      'type' => $display_type,
      'dimensions' => $dimensions,
    ];
    return [
      'data' => [$trace],
      'layout' => $layout + [
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Parallel Coordinates Plot'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
