<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'ribbon',
  label: new TranslatableMarkup('Ribbon Plots'),
  description: new TranslatableMarkup('Ribbon Plots'),
  example: 'https://plotly.com/javascript/ribbon-plots/',
  category: '3D Charts',
)]
class Ribbon implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $series = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      foreach (array_keys($options['fields']) as $field_name) {
        $series[$field_name][] = $view->style_plugin->getField($row_index, $field_name);
      }
    }
    $traces = [];
    $display_type = 'surface';
    $i = $j = 0;
    foreach ($series as $field_name => $values) {
      if ($j == 0) {
        $traces[$i] = [
          'type' => $display_type,
          'showscale' => FALSE,
          'opacity' => 0.9,
        ];
      }
      if ($j == 0) {
        $traces[$i]['x'] = $values;
      } elseif ($j == 1) {
        $traces[$i]['y'] = $values;
      } elseif ($j == 2) {
        $traces[$i]['z'] = $values;
      }
      $j++;
      if ($j == 3) {
        $i++;
        $j = 0;
      }
    }
    return [
      'data' => $traces,
      'layout' => $layout + [
        'scene' => [
          'xaxis' => ['title' => ['text' => $options['fields'][$options['label']]['name'] ?? '']],
          'yaxis' => ['title' => ['text' => $options['fields'][$field_name]['name'] ?? '']],
          'zaxis' => ['title' => ['text' => $options['fields'][$options['text']]['name'] ?? '']],
        ],
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Ribbon Plots'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
