<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'sankey',
  label: new TranslatableMarkup('Sankey Diagrams'),
  description: new TranslatableMarkup('Sankey Diagrams'),
  example: 'https://plotly.com/javascript/sankey-diagram/',
  category: 'Basic Charts',
)]
class Sankey implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $labels = $series = $values = $sources = $targets = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $labels[] = $view->style_plugin->getField($row_index, $options['label']);
      foreach (array_keys($options['fields']) as $field_name) {
        if ($field_name === $options['label']) {
          continue;
        }
        $value = $view->style_plugin->getField($row_index, $field_name);
        if ($field_name === $options['text']) {
          $values[$field_name][] = $value;
          continue;
        }
        if ($field_name === $options['parent']) {
          $sources[$field_name][] = $value;
          continue;
        }
        if ($field_name === $options['size']) {
          $targets[$field_name][] = $value;
          continue;
        }
        $series[$field_name][] = $value;
      }
    }
    $links = [
      'value' => reset($values),
      'source' => reset($sources),
      'target' => reset($targets),
    ];
    $display_type = 'sankey';
    $traces = [
      'type' => $display_type,
      'orientation' => 'h',
      'node' => [
        'pad' => 15,
        'thickness' => 30,
        'label' => $labels,
      ],
      'link' => $links,
    ];
    return [
      'data' => [$traces],
      'layout' => $layout + [
        'title' => ['text' => $options['title']],
      ],
      'annotations' => [
        [
          'text' => $options['description'],
          'xref' => 'paper',
          'yref' => 'paper',
          'y' => -0.1,
          'showarrow' => FALSE,
          'xanchor' => 'center',
          'yanchor' => 'top',
        ],
      ],
    ];
  }

}
