<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'surface',
  label: new TranslatableMarkup('Surface Plots'),
  description: new TranslatableMarkup('3D surface Plots'),
  example: 'https://plotly.com/javascript/3d-surface-plots/',
  category: '3D Charts',
)]
class Surface implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $z = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $value = [];
      foreach (array_keys($options['fields']) as $field_name) {
        $value[] = $view->style_plugin->getField($row_index, $field_name);
      }
      $z[] = $value;
    }
    $display_type = 'surface';
    $traces = [
      'z' => $z,
      'type' => $display_type,
    ];

    return [
      'data' => [$traces],
      'layout' => $layout + [
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Surface Plots'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
