<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'tables',
  label: new TranslatableMarkup('Tables'),
  description: new TranslatableMarkup('Tables'),
  example: 'https://plotly.com/javascript/table/',
  category: 'Basic Charts',
)]
class Tables implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $header = [];
    foreach ($options['fields'] as $field) {
      $header[] = $field['name'];
    }
    $values = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      foreach (array_keys($options['fields']) as $field_name) {
        $values[$field_name][] = $view->style_plugin->getField($row_index, $field_name);
      }
    }

    return [
      'data' => [
        [
          'type' => 'table',
          'header' => [
            'values' => $header,
            'align' => ["center"],
            'line' => ['width' => 1],
            'fill' => ['color' => "grey"],
            'font' => ['color' => 'white'],
          ],
          'cells' => [
            'values' => array_values($values),
            'align' => ["center"],
            'line' => ['width' => 1],
          ],
        ],
      ],
      'layout' => $layout + [
        'title' => ['text' => $options['title']],
        'annotations' => [
          [
            'text' => $options['description'],
            'showarrow' => FALSE,
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
