<?php

namespace Drupal\plotly\Plugin\PlotlyChart;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\plotly\Attribute\PlotlyChart;
use Drupal\plotly\PlotlyChartInterface;

/**
 * Plugin implementation of the plotly chart.
 */
#[PlotlyChart(
  id: 'waterfall',
  label: new TranslatableMarkup('Waterfall Charts'),
  description: new TranslatableMarkup('Waterfall Charts'),
  example: 'https://plotly.com/javascript/waterfall-charts/',
  category: 'Financial Charts',
)]
class Waterfall implements PlotlyChartInterface {

  /**
   * {@inheritDoc}
   */
  public function data(array $rows, array $options = [], $view = NULL, $layout = []): array {
    $display_type = 'waterfall';
    $x = $series = $texts = [];
    foreach ($rows as $row) {
      $render = $view->rowPlugin->render($row);
      $row_index = $render['#row']->index;
      $x[] = $view->style_plugin->getField($row_index, $options['label']);
      foreach (array_keys($options['fields']) as $field_name) {
        if ($field_name === $options['label']) {
          continue;
        }
        $value = $view->style_plugin->getField($row_index, $field_name);
        if ($field_name === $options['text']) {
          $texts[$field_name][] = $value;
          continue;
        }
        $series[$field_name][] = $value;
      }
    }
    $traces = [];
    foreach ($series as $field_name => $values) {
      $label = $options['fields'][$field_name]['name'] ?? $field_name;
      $traces[] = [
        'name' => $label,
        'x' => !empty($options['horizontal']) ? $values : $x,
        'y' => !empty($options['horizontal']) ? $x : $values,
        'orientation' => !empty($options['horizontal']) ? 'h' : '',
        'textposition' => 'outside',
        'text' => !empty($texts) ? current($texts) : '',
        'type' => $display_type,
      ];
    }
    return [
      'data' => $traces,
      'layout' => $layout + [
        'autosize' => TRUE,
        'showlegend' => TRUE,
        'xaxis' => ['type' => "category"],
        'yaxis' => ['type' => "linear"],
        'title' => [
          'text' => $options['title'] ?? new TranslatableMarkup('Waterfall charts'),
        ],
        'annotations' => [
          [
            'text' => $options['description'],
            'xref' => 'paper',
            'yref' => 'paper',
            'y' => -0.1,
            'showarrow' => FALSE,
            'xanchor' => 'center',
            'yanchor' => 'top',
          ],
        ],
      ],
    ];
  }

}
