> Pluggable Entity View Builder (PEVB)

Define entity view builders as plugins, defined per bundle.

## Quickstart

This module comes with an example module, so you could quickly give it a spin.

1. Enable "Pluggable Entity View Builder Example" module.
1. Clear cache, so the new settings will kick in.
1. Create a new Article node, along with the title, body some tags and an image.
At this point nothing should happen, as we haven't enabled the setting that
overrides core's default Node entity view builder.
1. Reload the article node, and see how it's theme has changed.
It will look roughly like this:

![Article node view](https://gitlab.com/drupalspoons/pluggable_entity_view_builder/uploads/a4023fdb7652a2ec039b5e69ce09d1fb/Selection_999_1093_.png)


## Paragraphs Integration

PEVB has integration with [Paragraphs](https://www.drupal.org/project/paragraphs)
module, as Paragraphs are nothing more than an entity, similar to a Node.

With Paragraphs module we may create landing pages such as the homepage, search
page, contact us, etc. that are highly customizable by site administrators.
This can be an alternative to core's Layout builder, in that it allows
developers to theme each element by itself, while site administrators can mix
and match those elements into a page.

See it in action:

1. Enable the "Pluggable Entity View Builder Paragraphs Example" module.
1. Article content type will now have a new "Paragraphs" field.
1. Create a few Paragraphs and view the node.


## Media Entities

PEVB supports Media entities, mainly to allow control of how they look when
added in content through the WYSIWYG editor.

Note that when media entities are referenced through a field in another entity
like a node that is being rendered with PEVB, you can theme the media directly
from that entity's PEVB, for fewer levels of indirections.
See `BuildFieldTrait::getMediaImageAndAlt()` for example.

## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined
and unified development process, is the recommended tool for contributing to the
module. The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib)
addon makes it easy to develop a Drupal module by offering the tools to set up
and test the module.

### Install DDEV

* Install a Docker provider by following DDEV [Docker Installation](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/)
  instructions for your Operating System.
* [Install DDEV](https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/),
  use the documentation that best fits your OS.
* DDEV is used mostly via CLI commands. [Configure shell completion &
  autocomplete](https://ddev.readthedocs.io/en/stable/users/install/shell-completion/)
  according to your environment.
* Configure your IDE to take advantage of the DDEV features. This is a critical
  step to be able to test and debug your module. Remember, the website runs
  inside Docker, so pay attention to these configurations:
    - [PhpStorm Setup](https://ddev.readthedocs.io/en/stable/users/install/phpstorm/)
    - [Configure](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/step-debugging/)
      PhpStorm and VS Code for step debugging.
    - Profiling with [xhprof](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xhprof-profiling/),
      [Xdebug](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xdebug-profiling/)
      and [Blackfire](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/blackfire-profiling/).

### Checkout the module

Normally, you check out the code form an [issue fork](https://www.drupal.org/docs/develop/git/using-gitlab-to-contribute-to-drupal/creating-issue-forks):

### Start DDEV

Inside the cloned project run:

```shell
ddev start
```

This command will fire up the Docker containers and add all configurations.

### Install dependencies

```shell
ddev poser
```

This will install the PHP dependencies. Note that this is a replacement for
Composer _install_ command that knows how to bundle together Drupal core and the
module. Read more about this command at
https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands

```shell
ddev symlink-project
```

This symlinks the module inside `web/modules/custom`. Read more about this
command at https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands.
Note that as soon as `vendor/autoload.php` has been generated, this command runs
automatically on every `ddev start`.

This command should also be run when adding new directories or files to the root
of the module.

```shell
ddev exec "cd web/core && yarn install"
```

Install Node dependencies. This is needed for the `ddev eslint` and `ddev
stylelint` commands.

### Install Drupal

```shell
ddev install
```

This will install Drupal and will enable the module.

### Changing the Drupal core version

* Create a file `.ddev/config.local.yaml`
* In the new config file, set the desired Drupal core version. E.g.,
  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.3
  ```
* Run `ddev restart`

Note that this file is not under VCS control. Refer to the original
documentation: [Changing the Drupal core version](https://github.com/ddev/ddev-drupal-contrib/blob/main/README.md#changing-the-drupal-core-version)

### Run tests

* `ddev phpunit`: run PHPUnit tests
* `ddev phpcs`: run PHP coding standards checks
* `ddev phpcbf`: fix coding standards findings
* `ddev phpstan`: run PHP static analysis
* `ddev eslint`: Run ESLint on Javascript and YAML files.
* `ddev stylelint`: Run Stylelint on CSS files.