<?php

namespace Drupal\pluggable_entity_view_builder_test\Plugin\EntityViewBuilder;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Render\Markup;
use Drupal\pluggable_entity_view_builder\BuildFieldTrait;
use Drupal\pluggable_entity_view_builder\EntityViewBuilderPluginAbstract;

/**
 * The "Entity Test Multilingual" plugin.
 *
 * @EntityViewBuilder(
 *   id = "entity_test_mul.entity_test_mul",
 *   label = @Translation("Entity Test - Multilingual"),
 *   description = "Entity view builder for Entity Test Multilingual."
 * )
 */
class EntityTestMul extends EntityViewBuilderPluginAbstract {

  use BuildFieldTrait;

  /**
   * Build the entity in 'full' view mode.
   *
   * @param array $build
   *   The build array.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity.
   *
   * @return array
   *   Render array.
   */
  public function buildFull(array $build, ContentEntityInterface $entity) {
    // Add the name to the output.
    $build[] = [
      '#type' => 'markup',
      '#markup' => Markup::create($entity->label()),
    ];
    // Output the referenced entities if any.
    if (!empty($entity->field_reference) && !$entity->field_reference->isEmpty()) {

      // Wrap element with a class, so it's easier to assert element in tests.
      // Normally we would use Twig for the wrapping class, however since this
      // is a test, we go for a simpler solution using the render API.
      $element = ['#type' => 'container'];
      $element['element'] = $this->buildReferencedEntities($entity->field_reference, 'full', $entity->language()->getId());
      $element['#attributes']['class'][] = 'entity-test-build-referenced-entities';

      $build[] = $element;

    }
    return $build;
  }

  /**
   * Build the entity in 'Card' view mode.
   *
   * @param array $build
   *   The build array.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity.
   *
   * @return array
   *   Render array.
   */
  public function buildCard(array $build, ContentEntityInterface $entity) {
    // Wrap element with a class to identify card view mode.
    $element = ['#type' => 'container'];
    $element['element'] = [
      '#type' => 'markup',
      '#markup' => Markup::create('Card: ' . $entity->label()),
    ];
    $element['#attributes']['class'][] = 'entity-test-build-view-mode-card';

    $build[] = $element;

    if (!empty($entity->field_reference) && !$entity->field_reference->isEmpty()) {
      $referenced_entities = $this->getReferencedEntitiesFromField($entity, 'field_reference');
      if (!empty($referenced_entities)) {
        $element = ['#type' => 'container'];
        $element['element'] = $this->buildReferencedEntities($entity->field_reference, 'full', $entity->language()->getId());
        $element['#attributes']['class'][] = 'entity-test-get-referenced-entities';
        $build[] = $element;
      }
    }

    return $build;
  }

  /**
   * Build using buildReferencedEntitiesWithViewModes.
   *
   * @param array $build
   *   The build array.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity.
   *
   * @return array
   *   Render array.
   */
  public function buildMultipleViewModes(array $build, ContentEntityInterface $entity) {
    // Add the name to the output.
    $build[] = [
      '#type' => 'markup',
      '#markup' => Markup::create($entity->label()),
    ];

    // Test buildReferencedEntitiesWithViewModes method.
    if (!empty($entity->field_reference) && !$entity->field_reference->isEmpty()) {
      // bundle_3 is not listed here, 'full' view mode is expected as fallback.
      $view_modes = [
        'bundle_1' => 'card',
        'bundle_2' => 'teaser',
      ];

      $element = ['#type' => 'container'];
      $element['element'] = $this->buildReferencedEntitiesWithViewModes(
        $entity->field_reference,
        $view_modes,
        $entity->language()->getId()
      );
      $element['#attributes']['class'][] = 'entity-test-build-referenced-entities-with-view-modes';

      $build[] = $element;
    }

    return $build;
  }

}
