<?php

namespace Drupal\pluggable_entity_view_builder_test\Plugin\EntityViewBuilder;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Render\Markup;
use Drupal\pluggable_entity_view_builder\EntityViewBuilderPluginAbstract;

/**
 * The "Entity Test Mul Bundle 1" plugin.
 *
 * @EntityViewBuilder(
 *   id = "entity_test_mul.bundle_1",
 *   label = @Translation("Entity Test Mul - Bundle 1"),
 *   description = "Entity view builder for Entity Test Mul Bundle 1."
 * )
 */
class EntityTestMulBundle1 extends EntityViewBuilderPluginAbstract {

  /**
   * Build the entity in 'card' view mode.
   *
   * @param array $build
   *   The build array.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity.
   *
   * @return array
   *   Render array.
   */
  public function buildCard(array $build, ContentEntityInterface $entity) {
    // Wrap element with a class to identify card view mode.
    $element = ['#type' => 'container'];
    $element['element'] = [
      '#type' => 'markup',
      '#markup' => Markup::create('Card: ' . $entity->label()),
    ];
    $element['#attributes']['class'][] = 'entity-test-build-view-mode-card';

    $build[] = $element;
    return $build;
  }

}
