<?php

namespace Drupal\pluggable_entity_view_builder_test\Plugin\EntityViewBuilder;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Render\Markup;
use Drupal\pluggable_entity_view_builder\EntityViewBuilderPluginAbstract;

/**
 * The "Entity Test Mul Bundle 2" plugin.
 *
 * @EntityViewBuilder(
 *   id = "entity_test_mul.bundle_2",
 *   label = @Translation("Entity Test Mul - Bundle 2"),
 *   description = "Entity view builder for Entity Test Mul Bundle 2."
 * )
 */
class EntityTestMulBundle2 extends EntityViewBuilderPluginAbstract {

  /**
   * Build the entity in 'teaser' view mode.
   *
   * @param array $build
   *   The build array.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity.
   *
   * @return array
   *   Render array.
   */
  public function buildTeaser(array $build, ContentEntityInterface $entity) {
    // Wrap element with a class to identify teaser view mode.
    $element = ['#type' => 'container'];
    $element['element'] = [
      '#type' => 'markup',
      '#markup' => Markup::create('Teaser: ' . $entity->label()),
    ];
    $element['#attributes']['class'][] = 'entity-test-build-view-mode-teaser';

    $build[] = $element;
    return $build;
  }

}
