<?php

namespace Drupal\pluggable_entity_view_builder_test\Plugin\EntityViewBuilder;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Render\Markup;
use Drupal\pluggable_entity_view_builder\EntityViewBuilderPluginAbstract;

/**
 * The "Entity Test Mul Bundle 3" plugin.
 *
 * @EntityViewBuilder(
 *   id = "entity_test_mul.bundle_3",
 *   label = @Translation("Entity Test Mul - Bundle 3"),
 *   description = "Entity view builder for Entity Test Mul Bundle 3."
 * )
 */
class EntityTestMulBundle3 extends EntityViewBuilderPluginAbstract {

  /**
   * Build the entity in 'full' view mode.
   *
   * @param array $build
   *   The build array.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity.
   *
   * @return array
   *   Render array.
   */
  public function buildFull(array $build, ContentEntityInterface $entity) {
    // Wrap element with a class to identify full view mode.
    $element = ['#type' => 'container'];
    $element['element'] = [
      '#type' => 'markup',
      '#markup' => Markup::create('Full: ' . $entity->label()),
    ];
    $element['#attributes']['class'][] = 'entity-test-build-view-mode-full';

    $build[] = $element;
    return $build;
  }

}
