<?php

namespace Drupal\plugin_configuration_field\Event;

/**
 * Defines the plugin configuration field types event.
 */
class PluginConfigurationFieldTypesEvent {

  /**
   * Constructs a new PluginConfigurationFieldTypesEvent object.
   *
   * @param array<string, string> $pluginTypes
   *   The plugin types, in the id => label format.
   */
  public function __construct(protected array $pluginTypes) {
  }

  /**
   * Gets the plugin types.
   *
   * @return array<string, string>
   *   The plugin types, in the id => label format.
   */
  public function getPluginTypes(): array {
    return $this->pluginTypes;
  }

  /**
   * Sets the plugin types.
   *
   * @param array $plugin_types
   *   The plugin types, in the id => label format.
   *
   * @return $this
   */
  public function setPluginTypes(array $plugin_types): self {
    $this->pluginTypes = $plugin_types;

    return $this;
  }

}
