<?php

namespace Drupal\plugin_configuration_field\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\plugin_configuration_field\Event\PluginConfigurationFieldEvents;
use Drupal\plugin_configuration_field\Event\PluginConfigurationFieldTypesEvent;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * Deriver for the "Plugin" field type.
 */
class PluginConfigurationFieldItemDeriver extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * Constructs a new PluginConfigurationFieldItemDeriver object.
   *
   * @param \Symfony\Component\EventDispatcher\EventDispatcherInterface $eventDispatcher
   *   The event dispatcher.
   */
  public function __construct(protected EventDispatcherInterface $eventDispatcher) {
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id): self {
    return new static(
      $container->get('event_dispatcher')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition): array {
    $event = $this->getEvent();
    $plugin_types = $event->getPluginTypes();

    foreach ($plugin_types as $plugin_type => $label) {
      $this->derivatives[$plugin_type] = [
        'plugin_type' => $plugin_type,
        'label' => $label,
        'category' => 'plugin_configuration_field',
      ] + $base_plugin_definition;
    }

    return parent::getDerivativeDefinitions($base_plugin_definition);
  }

  /**
   * Gets the event to dispatch.
   *
   * @return mixed
   *   The event.
   */
  protected function getEvent(): PluginConfigurationFieldTypesEvent {
    // This module has no way to list plugin types, so each plugin type
    // needs to register itself via the event.
    $plugin_types = [];
    $event = new PluginConfigurationFieldTypesEvent($plugin_types);
    $this->eventDispatcher->dispatch($event, PluginConfigurationFieldEvents::PLUGIN_CONFIGURATION_FIELD_TYPES);

    return $event;
  }

}
