<?php

namespace Drupal\plugin_configuration_field\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'Default' formatter.
 */
#[FieldFormatter(
  id: "plugin_configuration_field_default",
  label: new TranslatableMarkup("Default"),
  description: new TranslatableMarkup("Displays the plugin label or ID."),
  field_types: [
    "plugin_configuration_field",
  ],
)]
class PluginConfigurationFieldDefaultFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = [];
    foreach ($items as $delta => $item) {
      $target_definition = $item->getTargetDefinition();
      if (!empty($target_definition['label'])) {
        $elements[$delta] = [
          '#markup' => $target_definition['label'],
        ];
      }
      else {
        $elements[$delta] = [
          '#markup' => $target_definition['id'],
        ];
      }
    }

    return $elements;
  }

}
