<?php

namespace Drupal\plugin_configuration_field\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemInterface;

/**
 * Defines the interface for plugin configuration field item.
 */
interface PluginConfigurationFieldItemInterface extends FieldItemInterface {

  /**
   * Gets the target plugin definition.
   *
   * @return array
   *   The target plugin definition.
   */
  public function getTargetDefinition(): array;

  /**
   * Gets the target plugin instance.
   *
   * @param array $contexts
   *   (optional) An array of contexts to pass to the plugin manager when
   *   creating the plugin instance. Defaults to an empty array.
   *
   * @return object
   *   The target plugin instance.
   */
  public function getTargetInstance(array $contexts = []): object;

}
