<?php

namespace Drupal\plugin_configuration_field\Plugin;

use Drupal\Core\Entity\EntityInterface;

/**
 * Defines the interface for plugins that operate on an entity.
 */
interface PluginEntityInterface {

  /**
   * Gets the entity.
   *
   * @return \Drupal\Core\Entity\EntityInterface|null
   *   The entity.
   */
  public function getEntity(): ?EntityInterface;

  /**
   * Sets the entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity.
   *
   * @return $this
   */
  public function setEntity(EntityInterface $entity): self;

}
