<?php

namespace Drupal\plugin_configuration_field_test;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\plugin_configuration_field_test\Annotation\DummyType;
use Drupal\plugin_configuration_field_test\Plugin\DummyTypeInterface;

/**
 * Manages discovery and instantiation of dummy type plugins.
 */
class DummyTypeManager extends DefaultPluginManager {

  /**
   * Constructs a new DummyTypeManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache backend.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/DummyType',
      $namespaces,
      $module_handler,
      DummyTypeInterface::class,
      DummyType::class
    );

    $this->alterInfo('plugin_configuration_field_test_dummy_type_info');
    $this->setCacheBackend($cache_backend, 'plugin_configuration_field_test_dummy_type_plugins');
  }

}
