<?php

namespace Drupal\plugin_configuration_field_test\EventSubscriber;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\plugin_configuration_field\Event\PluginConfigurationFieldEvents;
use Drupal\plugin_configuration_field\Event\PluginConfigurationFieldTypesEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber for registering plugin configuration field types.
 */
class PluginConfigurationFieldTypesEventSubscriber implements EventSubscriberInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[PluginConfigurationFieldEvents::PLUGIN_CONFIGURATION_FIELD_TYPES][] = ['onPluginConfigurationFieldTypes'];

    return $events;
  }

  /**
   * Registers the 'dummy_type' plugin type.
   *
   * @param \Drupal\plugin_configuration_field\Event\PluginConfigurationFieldTypesEvent $event
   *   The plugin configuration field types event.
   */
  public function onPluginConfigurationFieldTypes(PluginConfigurationFieldTypesEvent $event): void {
    $types = $event->getPluginTypes();
    $types['dummy_type'] = $this->t('Basic dummy type');
    $event->setPluginTypes($types);
  }

}
