<?php

namespace Drupal\plugin_configuration_field_test\Plugin\DummyType;

use Drupal\Core\Form\FormStateInterface;
use Drupal\plugin_configuration_field_test\Plugin\DummyTypeBase;

/**
 * Provides the basic dummy type plugin.
 *
 * @DummyType(
 *   id = "dummy_type_basic",
 *   label = @Translation("Basic dummy type"),
 * )
 */
class BasicDummyType extends DummyTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'key_1' => NULL,
      'key_2' => [
        'key_2_1' => NULL,
        'key_2_2' => NULL,
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form = parent::buildConfigurationForm($form, $form_state);

    $form['#tree'] = TRUE;
    $form['key_1'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Value for key 1'),
      '#default_value' => $this->configuration['key_1'] ?? '',
      '#required' => TRUE,
    ];
    $form['key_2'] = [
      '#type' => 'container',
    ];
    $form['key_2']['key_2_1'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Value for key 2.1'),
      '#default_value' => $this->configuration['key_2']['key_2_1'] ?? '',
      '#required' => TRUE,
    ];
    $form['key_2']['key_2_2'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Value for key 2.2'),
      '#default_value' => $this->configuration['key_2']['key_2_2'] ?? '',
      '#required' => TRUE,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $values = [];

    // Ensure only expected keys are saved.
    $submitted_values = $form_state->getValue($form['#parents']);
    foreach (array_keys($this->defaultConfiguration()) as $key) {
      $value = $submitted_values[$key];

      // If the value is an array, ensure only expected sub-keys are saved.
      if (is_array($value)) {
        $values[$key] = [];
        foreach (array_keys($this->defaultConfiguration()[$key]) as $sub_key) {
          $values[$key][$sub_key] = $value[$sub_key];
        }
      }
      else {
        $values[$key] = $value;
      }
    }

    // Save the cleaned values.
    $this->setConfiguration($values);
  }

}
