<?php

namespace Drupal\Tests\plugin_configuration_field\Kernel;

use Drupal\Core\Entity\EntityInterface;
use Drupal\entity_test\Entity\EntityTest;
use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;
use Drupal\KernelTests\Core\Entity\EntityKernelTestBase;
use Drupal\plugin_configuration_field_test\Plugin\DummyType\BasicDummyType;

/**
 * Tests the plugin_configuration_field field.
 *
 * @group plugin_configuration_field
 */
class PluginConfigurationFieldItemTest extends EntityKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'plugin_configuration_field',
    'plugin_configuration_field_test',
  ];

  /**
   * A test entity.
   *
   * @var \Drupal\Core\Entity\EntityInterface|null
   */
  protected ?EntityInterface $testEntity = NULL;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $field_storage = FieldStorageConfig::create([
      'field_name' => 'plugin',
      'entity_type' => 'entity_test',
      'type' => 'plugin_configuration_field:dummy_type',
      'cardinality' => 1,
    ]);
    $field_storage->save();

    $field = FieldConfig::create([
      'field_name' => 'plugin',
      'entity_type' => 'entity_test',
      'bundle' => 'entity_test',
    ]);
    $field->save();

    $entity = EntityTest::create([
      'name' => 'Test',
    ]);
    $entity->save();
    $this->testEntity = $entity;
  }

  /**
   * Tests storing and retrieving the plugin reference and configuration.
   */
  public function testPluginConfigurationFieldItem(): void {
    $configuration = [
      'key_1' => 'value_1',
      'key_2' => [
        'key_2_1' => 'value_2_1',
        'key_2_2' => 'value_2_2',
      ],
    ];
    $entity = EntityTest::create([
      'plugin' => [
        [
          'target_plugin_id' => 'dummy_type_basic',
          'target_plugin_configuration' => $configuration,
        ],
      ],
    ]);
    $entity->save();

    /** @var \Drupal\plugin_configuration_field\Plugin\Field\FieldType\PluginConfigurationFieldItemInterface $plugin_field */
    $plugin_field = $entity->get('plugin')->first();
    $plugin = $plugin_field->getTargetInstance();
    $this->assertInstanceOf(BasicDummyType::class, $plugin);
    $this->assertEquals('dummy_type_basic', $plugin->getPluginId());
    $this->assertEquals($configuration, $plugin->getConfiguration());
    $this->assertEquals($plugin_field->getTargetDefinition(), $plugin->getPluginDefinition());

    // Ensure that it is possible to save without configuration.
    $entity = EntityTest::create([
      'plugin' => [
        [
          'target_plugin_id' => 'dummy_type_basic',
        ],
      ],
    ]);
    $entity->save();

    /** @var \Drupal\commerce\Plugin\Field\FieldType\PluginItem $condition_field */
    $plugin_field = $entity->get('plugin')->first();
    $plugin = $plugin_field->getTargetInstance();
    $this->assertInstanceOf(BasicDummyType::class, $plugin);
    $this->assertEquals('dummy_type_basic', $plugin->getPluginId());
    $this->assertEquals($plugin_field->getTargetDefinition(), $plugin->getPluginDefinition());
  }

}
