<?php

namespace Drupal\pluginreference\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a plugin reference selection item attribute object.
 *
 * Plugin Namespace: Plugin\PluginReferenceSelection.
 *
 * @see \Drupal\pluginreference\PluginReferenceSelectionManagerInterface
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class PluginReferenceSelection extends Plugin {

  /**
   * Constructs a PluginReferenceSelection attribute.
   *
   * @param string $id
   *   The plugin ID.
   *   There are some implementation bugs that make the plugin available only
   *   if the ID follows a specific pattern. It must be either identical to
   *   group or prefixed with the group. E.g. if the group is "foo" the ID must
   *   be either "foo" or "foo:bar".
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   (optional) The human-readable name of the selection plugin.
   * @param string[] $plugin_types
   *   (optional) An array of plugin types that can be referenced by this
   *   plugin. Defaults to all plugin types.
   * @param string|null $group
   *   (optional) The selection plugin group.
   *   This property is used to allow selection plugins to target a specific
   *   plugin type while also inheriting the code of an existing selection
   *   plugin. For example, if we want to override the block selection from
   *   the 'default' selection type, we can define the annotation of a new
   *   plugin as follows:
   *   @code
   *   id = "default:block_advanced",
   *   plugin_types = {"block"},
   *   group = "default",
   *   weight = 5
   *   @endcode
   * @param int|null $weight
   *   (optional) The weight of the plugin in its group.
   *   This property is used to select the "best" plugin within a group.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label = NULL,
    public readonly array $plugin_types = [],
    public readonly ?string $group = NULL,
    public readonly ?int $weight = NULL,
    public readonly ?string $deriver = NULL,
  ) {}

}
