<?php

namespace Drupal\pluginreference_test\Plugin\PluginReferenceSelection;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\pluginreference\Attribute\PluginReferenceSelection;
use Drupal\pluginreference\Plugin\PluginReferenceSelection\DefaultSelection;

/**
 * Provides a plugin reference selection for field widgets.
 *
 * This class is used in the tests to check the weight and grouping.
 */
#[PluginReferenceSelection(
  id: 'default:field_widget_test',
  label: new TranslatableMarkup('Default'),
  plugin_types: ['field.widget'],
  group: 'default',
  weight: 10,
)]
class FieldWidgetTestSelection extends DefaultSelection {

}
