# Plural variants serialization

[![https://drupalcode.org/project/plural_serialization/badges/1.x/pipeline.svg](https://drupalcode.org/project/plural_serialization/badges/1.x/pipeline.svg)](https://drupalcode.org/project/plural_serialization)

A lightweight module that exports plural label strings as plain sequence instead of binary string. On import, it reverts back to a binary string where the plural variants are concatenated by the ETX (End of text) character. This allows to make readable the plural labels when they are exported in YAML files.

For more background see https://www.drupal.org/project/drupal/issues/2829919.

## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined and unified development process, is the recommended tool for contributing to the module. The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib) addon makes it easy to develop a Drupal module by offering tools to set up and test the module.

### Install DDEV

* Install a Docker provider by following the DDEV [Docker Installation](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/) instructions for your operating system.
* [Install DDEV](https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/), using the documentation that best fits your OS.
* DDEV is used mostly via CLI commands. [Configure shell completion & autocomplete](https://ddev.readthedocs.io/en/stable/users/install/shell-completion/) according to your environment.
* Configure your IDE to take advantage of the DDEV features. This is a critical step for testing and debugging your module. Remember, the website runs inside Docker, so pay attention to these configurations:
  - [PhpStorm Setup](https://ddev.readthedocs.io/en/stable/users/install/phpstorm/)
  - [Configure](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/step-debugging/) PhpStorm and VS Code for step debugging.
  - Profiling with [xhprof](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xhprof-profiling/), [Xdebug](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xdebug-profiling/), and [Blackfire](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/blackfire-profiling/).

### Checkout the module

Normally, you check out the code from an [issue fork](https://www.drupal.org/docs/develop/git/using-gitlab-to-contribute-to-drupal/creating-issue-forks):

```shell
git clone git@git.drupal.org:issue/plural_serialization-[issue number].git
cd plural_serialization-[issue number]
```

### Start DDEV

Inside the cloned project, run:

```shell
ddev start
```

This command will start the Docker containers and apply all configurations.

### Install dependencies

```shell
ddev poser
```

This installs the PHP dependencies. Note that this is a replacement for the Composer _install_ command that knows how to bundle Drupal core with the module. Read more about this command at [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands).

```shell
ddev symlink-project
```

This symlinks the module inside `web/modules/custom`. Read more about this command at the same [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands) link.
Note: As soon as `vendor/autoload.php` is generated, this command runs automatically on every `ddev start`.

Run this command manually after adding new directories or files to the root of the module.

```shell
ddev exec "cd web/core && yarn install"
```

Installs Node.js dependencies. This is required for the `ddev eslint` command.

### Install Drupal

```shell
ddev install
```

This installs Drupal and enables the module.

### Changing the Drupal core and PHP versions

* Create a `.ddev/config.local.yaml` file.
* Set the desired Drupal core and PHP versions. For example:
  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.5
  php_version: "8.1"
  ```
* Run `ddev restart`

### Run tests

* `ddev phpunit` — run PHPUnit tests
* `ddev phpcs` — run PHP coding standards checks
* `ddev phpcbf` — fix coding standards issues
* `ddev phpstan` — run PHP static analysis
* `ddev eslint` — run ESLint on YAML files
