# PM Carousel

The PM-Carousel module provides a custom field formatter to display entity reference fields as carousels using PM-Carousel JS library.
> PM-Carousel, for "Pimp My Carousel" is a pretty small, accessible and vanilla JavaScript to manage your carousels. It has no dependencies!

- PM-Carousel JS library documentation can be found here : https://github.com/lordfpx/pm-carousel
- PM-Carousel JS library showcase can be found here : https://lordfpx.github.io/pm-carousel
## Table of contents

- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)

---

## Requirements

This module requires no additional modules.

---

## Installation

1. Install as you would normally install a contributed Drupal module. For further information,
see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).
2. Download PM-Carousel JS library [pm-carousel library](https://github.com/lordfpx/pm-carousel)
3. Copy `pm-carousel.umd.js` file in the `/libraries/pm-carousel/dist/` folder of your site
---

## Configuration

3. Enable the module at **Administration > Extend**.
4. Navigate to the "Manage Display" tab of the desired entity reference field.
5. Select `PM Carousel container` as the formatter for the field.
6. Configure the formatter settings
7. Save and view your content to see the carousel in action.

### YAML configuration example

```yml
default:
    loop: false
    group: 1
    spaceAround: 0
    noStartSpace: true
    autoplay: 0
responsive:
    - { minWidth: 1024px, disable: false }
    - { minWidth: '0', disable: true }
```
