// eslint-disable-next-line func-names
((Drupal, once, pmCarousel) => {
  // Define a behavior object to provide interaction capability for PM Carousel
  Drupal.behaviors.pmCarousel = {
    attach(context, drupalSettings) {
      const pmcSettings = drupalSettings.pmCarousel;
      Object.keys(pmcSettings).forEach((key) => {
        const selector = `[data-pm-carousel][data-settings-key="${key}"]`;
        // Retrieve carousel elements using Drupal's once() function
        const carousels = once('pm-carousel', selector, context);
        if (carousels.length > 0) {
          // Retrieve PM Carousel settings.
          const settings = pmcSettings[key];
          // Iterate over each carousel element
          carousels.forEach((carousel) => {
            // Initialize PM Carousel with settings or set default values
            pmCarousel(settings, carousel);
          });
        }
      });
    },
  };
})(Drupal, once, window.pmCarousel);
