<?php

namespace Drupal\pm_carousel_tobii\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\lightbox\LightboxFormatterTrait;
use Drupal\lightbox_media\Plugin\Field\FieldFormatter\LightboxMediaContainerFormatterTrait;
use Drupal\lightbox_tobii\LightboxTobiiUtils;
use Drupal\lightbox_tobii\Plugin\Field\FieldFormatter\LightboxTobiiFormatterTrait;
use Drupal\pm_carousel\Plugin\Field\FieldFormatter\PmCarouselContainerFormatter;

/**
 * Plugin implementation of the 'pm_carousel_tobii_media_container' formatter.
 */
#[FieldFormatter(
  id: 'pm_carousel_tobii_media_container',
  label: new TranslatableMarkup('PM Carousel in Tobii container'),
  field_types: [
    'entity_reference',
  ],
)]
class PmCarouselTobiiMediaContainerFormatter extends PmCarouselContainerFormatter {

  use LightboxFormatterTrait;
  use LightboxTobiiFormatterTrait;
  use LightboxMediaContainerFormatterTrait;

  /**
   * {@inheritDoc}
   */
  public static function defaultSettings() {
    return self::getTobiiSettings() + self::getContainerSettings() + parent::defaultSettings();
  }

  /**
   * {@inheritDoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $form = parent::settingsForm($form, $form_state);

    $this->containerSettingsForm($form);

    $this->tobiiSettingsForm($form);

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {

    $summary = parent::settingsSummary();

    $this->containerSettingsSummary($summary);

    $this->tobiiSettingsSummary($summary);

    return $summary;
  }

  /**
   * {@inheritDoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    // Get the parent class elements.
    $elements = parent::viewElements($items, $langcode);

    $this->containerWrapper($items, $langcode, $elements);

    LightboxTobiiUtils::attachLibraryAndSettings($this, $elements);

    return $elements;
  }

}
