(function (Drupal) {
  Drupal.behaviors.customPopup = {
    attach: function (context, settings) {
      const overlay = context.querySelector('#popup-overlay');
      const closeBtn = context.querySelector('.popup-close-btn');

      // Check storage using the new key 'customPopupClosed'
      if (overlay && !sessionStorage.getItem('customPopupClosed')) {
        
        setTimeout(() => {
          overlay.classList.add('is-visible');
        }, 500);

        const closePopup = () => {
          overlay.classList.remove('is-visible');
          sessionStorage.setItem('customPopupClosed', 'true');
        };

        if (closeBtn) {
          closeBtn.addEventListener('click', closePopup);
        }
        
        overlay.addEventListener('click', (e) => {
          if (e.target === overlay) {
            closePopup();
          }
        });
      }
    }
  };
})(Drupal);