# Postal Mail Delivery Platform Integration

>[Postal](https://docs.postalserver.io/) is a complete and fully featured mail delivery platform for use by websites &
>web servers. Think Sendgrid, Mailgun or Postmark but open source and ready for you to run on your own servers.

## Table of contents

- Features
- Requirements
- Installation
- Configuration
- Maintainers


## Features

This module makes it possible to send mail from Drupal using the Postal API. The functionality is provided as a plugin.
Use the the [Mail System](https://www.drupal.org/projec/mailsystem) module to configure Postal as the site default
mail system or configure specific modules to use Postal as the mail system.


## Requirements

- The [Mail System](https://www.drupal.org/project/mailsystem) module
- A Postal account with API credentials


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

Configure the module using the settings form available at `/admin/config/services/postal` and select *Postal Mail
Delivery Platform* as the default mail system for both formatter and sender or configure specific modules to use
*Postal Mail Delivery Platform* via the *Mail System* configuration available at `/admin/config/system/mailsystem`.


### Webhooks

The module provides a webhook endpoint that can be used to track mail delivery status. The endpoint is available at
`/postal/webhook`. The endpoint is protected by a secret key that can be configured in the settings form available at
`/admin/config/services/postal`.

When a webhook is received the module will dispatch a `\Drupal\postal_mail\Event\WebhookEvent` event that can be
subscribed to in custom code. The event contains the payload as specified in the [Postal API documentation](https://docs.postalserver.io/developer/webhooks).

It is also possible to use the [Webhooks](https://www.drupal.org/project/webhooks) module if you want a more
"site builder" friendly way to configure and work with webhooks.

## Maintainers

Current maintainers:

- [Peter Törnstrand](https://www.drupal.org/u/peter-tornstrand)

### Credits

This module is heavily inspired by the [Mailchimp Transactional](https://www.drupal.org/project/mailchimp_transactional)
module.

### Supporting organizations

The Drupal module *Postal Mail Delivery Platform Integration* was developed by [Peter Törnstrand](https://www.drupal.org/u/peter-tornstrand)
and sponsored by [Happiness Web Agency](https://www.happiness.se) in the beautiful city of Stockholm, Sweden.
