<?php

/**
 * @file
 * This file contains no working PHP code.
 *
 * It exists to provide additional documentation for doxygen as well as to
 * document hooks in the standard Drupal manner.
 */

declare(strict_types=1);

/**
 * Allows other modules to alter the allowed attachment file types.
 *
 * @array $types
 *   An array of file types indexed numerically.
 */
function hook_postal_mail_valid_attachment_types_alter(&$types): void {
  // Example, allow word docs:
  $types[] = 'application/msword';
  // Allow openoffice docs:
  $types[] = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
}

/**
 * Alter the message data before it is sent to the Postal API.
 *
 * @param array $data
 *   The postal message data as described in http://apiv1.postalserver.io/controllers/send/message
 * @param array $message
 *   A message array, as described in hook_mail_alter().
 */
function hook_postal_mail_alter(array &$data, array &$message): void {
  // Add a custom header:
  $data['headers']['X-Custom-Header'] = 'Custom Value';

  // Add a tag:
  $data['tag'] = 'my-tag';
}
