<?php

declare(strict_types=1);

namespace Drupal\postal_mail\Plugin\QueueWorker;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\postal_mail\PostalAPI;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Sends queued mail messages.
 *
 * @QueueWorker(
 *   id = "postal_mail_queue",
 *   title = @Translation("Sends queued mail messages"),
 *   cron = {"time" = 60}
 * )
 */
class PostalQueueWorker extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  protected PostalAPI $postalAPI;

  /**
   * PostalQueueWorker constructor.
   */
  final public function __construct(array $configuration, $plugin_id, $plugin_definition, PostalAPI $postal_api) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->postalAPI = $postal_api;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('postal_mail.api')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    $this->postalAPI->send($data);
  }

}
