<?php

declare(strict_types=1);

namespace Drupal\posthog_feature_flags\Plugin\Condition;

use Drupal\Core\Condition\ConditionPluginBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\posthog\UserAttributesProvider;
use Drupal\posthog_php\SdkDecoratorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a 'Posthog Feature Flag' condition.
 *
 * @todo Implement
 *
 * @Condition(
 *   id = "posthog_feature_flags",
 *   label = @Translation("Posthog Feature Flag"),
 * )
 */
final class PosthogFeatureFlags extends ConditionPluginBase implements ContainerFactoryPluginInterface {

  /**
   * Constructs a new PosthogFeatureFlags instance.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    private readonly ConfigFactoryInterface $configFactory,
    protected readonly SdkDecoratorInterface $posthogPhpSdk,
    protected readonly UserAttributesProvider $posthogUserHelper,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new self(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('config.factory'),
      $container->get('posthog_php.sdk_decorator'),
      $container->get('posthog_php.user_helper'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return ['example' => ''] + parent::defaultConfiguration();
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form['example'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Example'),
      '#default_value' => $this->configuration['example'],
    ];
    return parent::buildConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $this->configuration['example'] = $form_state->getValue('example');
    parent::submitConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function summary(): string {
    return (string) $this->t(
      'Example: @example', ['@example' => $this->configuration['example']],
    );
  }

  /**
   * {@inheritdoc}
   */
  public function evaluate(): bool {
    // @todo Evaluate the condition here.
    $posthogUserId = $this->posthogUserHelper->getDistinctId();
    $this->posthogPhpSdk->getAllFlags($posthogUserId);

    return TRUE;
  }

}
