# PostHog JS SDK & Tracking

This module connects with the client-side PostHog JavaScript SDK and tracking.


## Requirements

This module requires the following modules / libraries:

- **[PostHog Analytics Integration](https://www.drupal.org/project/posthog)** - Module


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

For a full list of initialization configuration options for the settings at
`/admin/config/services/posthog/js`, see the
[PostHog documentation](https://posthog.com/docs/libraries/js).

If you would like to provide cookie-less tracking, do the following:
- Go to `/admin/config/services/posthog/js` and add:
~~~ json
persistence: "memory"
~~~
- Now all user data will be saved in page memory, which means data is only
persistent for the duration of the page view. For more information about the
"persistence" key, see the
[PostHog documentation](https://posthog.com/docs/libraries/js#persistence).
- Alternatively, you could also use the "PostHog COOKiES" submodule, which
automatically sets this value if the user has not accepted the associated
cookies service.
