<?php

/**
 * @file
 * Example hook implementations for the posthog_php module.
 */

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alters the posthog php capture "message" array.
 *
 * @param array $message
 *   The message array to be sent to PostHogs "capture" call.
 *   Structure: [
 *     'distinctId' => 'distinct_id',
 *     'event' => 'event_name',
 *     'properties' => [
 *       'property_key' => 'property_value',
 *      ],
 *     ].
 * @param mixed $context
 *   Context variables related to where the capture event was emitted.
 *   For example, the user (user) of the user who triggered the event.
 *   Commerce events also have the order (commerce_order), as a context
 *   variable.
 *
 * @see https://posthog.com/docs/libraries/php
 * @see https://posthog.com/docs/product-analytics/capture-events?tab=PHP
 */
function hook_posthog_capture_alter(array &$message, array $context = []) {
  // Example: Conditionally add a custom property to the message array:
  if ($message['event'] === 'user_login') {
    $message['properties']['login_time'] = time();
    if (isset($context['user'])) {
      $message['properties']['uid'] = $context['user']->id();
    }
  }
}
