/**
 * @file
 * Defines Javascript behaviors for the cookies module.
 */
(function (Drupal) {
  /**
   * Define defaults.
   */
  Drupal.behaviors.posthog_cookies = {
    consentGiven() {
      if (
        window.posthog?.has_opted_out_capturing &&
        window.posthog.has_opted_out_capturing()
      ) {
        window.posthog?.opt_in_capturing?.();
      }
    },
    consentDenied() {
      if (
        window.posthog?.has_opted_out_capturing &&
        !window.posthog.has_opted_out_capturing()
      ) {
        window.posthog?.opt_out_capturing?.();
      }
    },

    attach(context) {
      const self = this;
      document.addEventListener('cookiesjsrUserConsent', function (event) {
        const service =
          typeof event.detail.services === 'object'
            ? event.detail.services
            : {};
        if (typeof service.posthog !== 'undefined' && service.posthog) {
          self.consentGiven(context);
        } else {
          self.consentDenied(context);
        }
      });
    },
  };
})(Drupal);
