<?php

declare(strict_types=1);

namespace Drupal\posthog_js;

use Drupal\Core\Render\BubbleableMetadata;

/**
 * Interface for the VisibilityTracker.
 */
interface ConditionsCheckerInterface {

  /**
   * Check if the conditions apply.
   *
   * @return bool
   *   TRUE if the conditions match, FALSE otherwise.
   */
  public function apply(?BubbleableMetadata $bubbleable_metadata = NULL): bool;

}
