<?php

declare(strict_types=1);

namespace Drupal\posthog_php_events\EventSubscriber;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\posthog_php\SdkDecoratorInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Posthog PHP event subscriber.
 */
final class PosthogPhpEventsSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a PosthogPhpEventsSubscriber object.
   */
  public function __construct(
    protected readonly ConfigFactoryInterface $configFactory,
    protected readonly SdkDecoratorInterface $posthogPhpSdk,
  ) {}

  /**
   * {@inheritDoc}
   */
  public static function getSubscribedEvents() {
    return [
      KernelEvents::RESPONSE => ['onResponse', 0],
    ];
  }

  /**
   * Allows tracking events for main page requests and AJAX requests.
   *
   * @param \Symfony\Component\HttpKernel\Event\ResponseEvent $event
   *   Response event object.
   */
  public function onResponse(ResponseEvent $event): void {
    if (!$event->isMainRequest()) {
      return;
    }
    // $response = $event->getResponse();
    // $isAjaxResponse = $response instanceof AjaxResponse;
    // @todo Track event
  }

}
