# PostHog Analytics Integration

The PostHog Analytics Integration module serves as an integration of various
services from PostHog Analytics into your Drupal site.

- View any shared PostHog dashboard directly through the Drupal admin UI
- Integrate PostHog feature flags into your site
- Integrate PostHog into the
[Drupal Commerce](https://www.drupal.org/project/commerce) and
[Webform](https://www.drupal.org/project/webform) systems
- Manage PostHog with the
[COOKiES Consent Management](https://www.drupal.org/project/cookies) module
- Integrate PostHog events with the
[ECA](https://www.drupal.org/project/eca) module
- Make use of both the client-side (JavaScript) and server-side (PHP) PostHog
APIs (including server-side error and event tracking)

For more information about PostHog and related services, visit the
[PostHog website](https://posthog.com).

For a full description of the module, visit the
[project page](https://www.drupal.org/project/posthog).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/posthog).


## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

While the configuration depends on the PostHog integrations that you would like
to utilize, generally, all configuration options for this module and its
submodules are located at *Administration » Configuration » Web services »
PostHog settings*.
