<?php

namespace Drupal\posthog_commerce\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\posthog_commerce\EventSubscriber\CartSubscriber;
use Drupal\posthog_commerce\EventSubscriber\OrderSubscriber;

/**
 * Configure Posthog Commerce settings for this site.
 */
class PosthogCommerceSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'posthog_commerce_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['posthog_commerce.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('posthog_commerce.settings');

    $form['events'] = [
      '#type' => 'details',
      '#title' => $this->t('Events'),
      '#open' => TRUE,
    ];

    $form['events']['track_commerce_cart_entity_added'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Track commerce cart entity added'),
      '#description' => $this->t('Event name is %eventName.', [
        '%eventName' => OrderSubscriber::POSTHOG_ORDER_COMPLETED_EVENT,
      ]),
      '#default_value' => $config->get('track_commerce_cart_entity_added'),
    ];
    $form['events']['track_commerce_order_completed'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Track Commerce order completed'),
      '#description' => $this->t('Event name is %eventName.', [
        '%eventName' => CartSubscriber::POSTHOG_CART_ADD_EVENT,
      ]),
      '#default_value' => $config->get('track_commerce_order_completed'),
    ];
    // @todo Implement this event in the future:
    // $form['events']['track_commerce_order_paid'] = [
    // '#type' => 'checkbox',
    // '#title' => $this->t('Track Commerce order paid'),
    // '#description' => $this->t('Event name is "Order paid".'),
    // '#default_value' => $config->get('track_commerce_order_paid'),
    // ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('posthog_commerce.settings')
      ->set('track_commerce_cart_entity_added', $form_state->getValue('track_commerce_cart_entity_added'))
      ->set('track_commerce_order_completed', $form_state->getValue('track_commerce_order_completed'))
      // @todo Implement this event in the future:
      // ->set('track_commerce_order_paid',
      // $form_state->getValue('track_commerce_order_paid'))
      ->save();
    // @todo Do we need to clear some kind of event cache here?
    parent::submitForm($form, $form_state);
  }

}
